import opentrons
import pandas as pd 
from opentrons import protocol_api
import sys #Lines 4-6 are uneccessary unless you are simulating
import json 
from opentrons.simulate import simulate, format_runlog






metadata = {
    'apiLevel': '2.9',
    'author': 'Justin Napolitano <jmnapol@g.clemson.edu>',
    'protocolName': 'Mastermix Loading 12 F',

    'description': 'Protocol for making 12 full plates plates of mastermix'
    }

def run(protocol: protocol_api.ProtocolContext):
    
    
    plate_1 = protocol.load_labware('greiner_384_wellplate_25ul', '1')
    plate_2 = protocol.load_labware('greiner_384_wellplate_25ul', '2')
    plate_3 = protocol.load_labware('greiner_384_wellplate_25ul', '3')
    plate_4 = protocol.load_labware('greiner_384_wellplate_25ul', '4')
    plate_5 = protocol.load_labware('greiner_384_wellplate_25ul', '5')
    plate_6 = protocol.load_labware('greiner_384_wellplate_25ul', '6')
    plates = [plate_1,plate_2,plate_3,plate_4,plate_5,plate_6]
                      
    plate_positions = []
    letters = ['A','B']
    for i in range (1,25,1):
        for j in range(0,2,1):
            plate_positions.append(letters[j] + str(i))

    
    tiprack_11 = protocol.load_labware('opentrons_96_filtertiprack_20ul', '11')
    
    
    deep_10 = protocol.load_labware('nest_96_wellplate_2ml_deep', '10')
    
    deep_positions = ['A1','A2','A3','A4']

    trash = protocol.load_labware('opentrons_1_trash_1100ml_fixed', '12')
    
    
    pipettes = protocol.load_instrument('p20_multi_gen2', mount='left', tip_racks=[tiprack_11])
    #pipettes.flow_rate.dispense = 1.5
    #pipettes.flow_rate.aspirate = 1.5
    #pipettes.flow_rate.blow_out = 15
    
    robot_model = 'OT-2 Standard'


    for q in range(0,2,1):
        for k in range(0,len(plates),1):
            pipettes.pick_up_tip()
            for j in range(0,int(len(plate_positions)),1): #Wells
                r = (2 * q) + (j // 4)
                pipettes.transfer(8,[deep_10.wells_by_name()[well_name] for well_name in [deep_positions[r]]],
                                  [plates[k].wells_by_name()[well_name_2] for well_name_2 in [plate_positions[j]]],
                                  new_tip = 'never')              
            pipettes.drop_tip()
        if q == 0:
            protocol.pause('First Batch of Plates are Complete - Add 6 New Plates') #This pauses the code and requires user input to continue driving
    
        